///
// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_cxx.rb
//

int absint(int n){ return (n < 0)?-n:n; }
int absdouble(double n){ return (n < 0)?-n:n; }
int signe(int n){ return (n >= 0)? 1: -1; }
const int INFINI = 1000*1000*1000;

#include "prologin.hh"
#include <vector>
#include <algorithm>
#include <cstdio>
#include <cmath>

bool operator == (const position& a, const position& b){ return a.x == b.x && a.y == b.y; }
bool operator != (const position& a, const position& b){ return !(a == b); }

///
// Fonction appelée au début de la partie.
//
void partie_init()
{
  // fonction a completer
}

struct Action
{
    position portail;
    int nbBoucliers;
    Action(){ portail.x = -1; }
    Action(position p, int n){ portail = p, nbBoucliers = n; }
};

const double expGains = 1.0;
const double expCout = 1.0;
const double expDist = 1.0;

struct Portail
{
    position pos;
    int pertesEnemis;
    int gains;
    int dist;
    int coutAttaque;
    
    const double gagnee() {
        if (gains < 1 && pertesEnemis > 0)
            return 0;
        return gains + pertesEnemis;
    }
    const double cout() {
        return (double)coutAttaque + ((double)dist) * 6.0;
        //return (double)coutAttaque;
    }
    const double valDist() {
        return absdouble((double)dist - 4.0001);
    }
    
    const double codeValeur() {
        return std::pow(gagnee(), expGains) / ( std::pow(cout(), expCout));
    }
    
};

int proteger(const Portail& a)
{
    //return std::min(1 + a.gains / 10, 4);
    return 2;
}

/*const int debInterDistOpti = 4;
const int finInterDistOpti = 10;
const int moyenneOpti = 7;*/

const int distOpti = 3;
const int distMax = 12;
const int distMin = 2;
const int distEcart = 3;

bool operator < (const Portail& a, const Portail& b)
{
    if (a.dist == 0 || (a.gains == 0 && a.pertesEnemis == 0))
        return false;
    if (b.dist == 0 || (b.gains == 0 && b.pertesEnemis == 0))
        return true;
    
    if (a.dist < distMin && b.dist >= distMin)
        return false;
    if (a.dist >= distMin && b.dist < distMin)
        return true;
    
    /*if (a.dist > distMax && b.dist <= distMax)
        return false;
    if (a.dist <= distMax && b.dist > distMax)
        return true;*/
    
    Portail a2 = a, b2 = b;
    if (std::abs(a2.dist - b2.dist) <= distEcart)
        return a2.gagnee() > b2.gagnee();
        //return a2.codeValeur() > b2.codeValeur();
    return a2.dist < b2.dist;
    
}

Action actionFind()
{
    //printf("\naction find\n");
    std::vector<position> portails = liste_portails();
    std::vector<Portail> suivants;
    
    for (int i = 0; i < (int)portails.size(); i++)
        if (!case_dans_champ(portails[i]) && portail_joueur(portails[i]) != moi())
        {
            Portail port;
            port.pos = portails[i];
            port.dist = absint(portails[i].x-position_agent(moi()).x) + absint(portails[i].y-position_agent(moi()).y);
            port.coutAttaque = COUT_CAPTURE;
            if (portail_boucliers(portails[i]) > 0)
                port.coutAttaque += portail_boucliers(portails[i]) * COUT_NEUTRALISATION_BOUCLIER;
            if (portail_joueur(portails[i]) > -1)
                port.coutAttaque += COUT_NEUTRALISATION;
            if (portail_joueur(portails[i]) == moi())
                port.coutAttaque = 0;
            
            port.pertesEnemis = 0;
            //if (portail_joueur(portails[i]) == adversaire())
            //{
                std::vector<champ> champsEnemis = champs_incidents_portail(portails[i]);
                for (int iChamp = 0; iChamp < (int)champsEnemis.size(); iChamp++)
                    port.pertesEnemis += score_triangle(champsEnemis[iChamp].som1, champsEnemis[iChamp].som2, champsEnemis[iChamp].som3);
            //}
            
            //if (!case_dans_champ(portails[i]))
            //{
                port.gains = 0;
                std::vector<lien> liens = liste_liens();
                for (int iLien = 0; iLien < (int)liens.size(); iLien++)
                {
                    lien li = liens[iLien];
                    if (li.joueur_l == moi()) //&& !lien_existe(portails[i], li.extr1) && !lien_existe(portails[i], li.extr2))
                    {
                        std::vector<lien> coupes = liens_bloquants(portails[i], li.extr1);
                        std::vector<lien> coupes2 = liens_bloquants(portails[i], li.extr2);
                        for (int a = 0; a < (int)coupes2.size(); a++)
                            coupes.push_back(coupes2[a]);
                        bool estCoupe = false;
                        
                        for (int iCoupe = 0; iCoupe < (int)coupes.size(); iCoupe++)
                            if (coupes[iCoupe].extr1 != portails[i] && coupes[iCoupe].extr2 != portails[i]) {
                                estCoupe = true;
                                break;
                            }
                        if (!estCoupe)
                        {
                            port.gains += score_triangle(portails[i], li.extr1, li.extr2);
                        }
                    }
                }
            //}
            
            suivants.push_back(port);
            
        }
    
    position posMeil; posMeil.x = -1; posMeil.y = -1;
    int nbBoucliers = 0;
    std::sort(suivants.begin(), suivants.end());
    
    for (int isuiv = 0; isuiv < (int)suivants.size(); isuiv++)
    {
        //printf ("suivant possible pos %d %d pertesEnemis %d gains %d dist %d coutAttaque %d de valeur %lf\n", suivants[isuiv].pos.x, suivants[isuiv].pos.y, suivants[isuiv].pertesEnemis, suivants[isuiv].gains, suivants[isuiv].dist, suivants[isuiv].coutAttaque, suivants[isuiv].codeValeur());
    }
    
    if ((int)suivants.size() > 0)
    {
        int iChoisit = 0;
        posMeil = suivants[iChoisit].pos;
        nbBoucliers = proteger(suivants[iChoisit]);
        //printf("\n go sur la case de code %lf, suivant de valeur %lf\n", suivants[iChoisit].codeValeur(), suivants[iChoisit+1].codeValeur());
    }
    
    return Action(posMeil, nbBoucliers);
    
}

bool termineLiens = true;

bool jouerAction(Action& act, int& nbDeps, int& nbPts)
{
    if (act.portail.x == -1)
        return true;
    
    //printf ("je joue une action... joueur de la case %d %d: %d", act.portail.x, act.portail.y, portail_joueur(act.portail));
    position pos = position_agent(moi());
    //printf("position de moi %d %d\n", pos.x, pos.y);
    // go vers ledit lieu
    
    if (pos.x != act.portail.x || pos.y != act.portail.y) // deplacer
    {
        //printf("deplacement\n");
        position go = act.portail;
        int dist = absint(go.x-pos.x) + absint(go.y-pos.y);
        
        while (nbDeps < dist && nbPts >= COUT_TURBO) {
            nbDeps++, nbPts -= COUT_TURBO;
            utiliser_turbo();
        }
        
        int depX = std::min(absint(pos.x-go.x), nbDeps) * signe(go.x-pos.x);
        nbDeps -= abs(depX);
        int depY = std::min(absint(pos.y-go.y), nbDeps) * signe(go.y-pos.y);
        nbDeps -= abs(depY);
        
        pos.x += depX; pos.y += depY;
        
        erreur e = deplacer(pos);
        if (e != OK)
            //printf("erreur!!! \n");
        if (e == PA_INSUFFISANTS)
            //printf("pas assez de pa\n");
        if (e == POSITION_INVALIDE)
            //printf("pos invalide\n");
        if (e == POSITION_ELOIGNEE)
            //printf("pos trop loin\n");
        
        if (pos.x != go.x || pos.y != go.y)
            return false;
    }
    
    // neutraliser
    
    if (portail_joueur(pos) == adversaire())
    {
        int cout = portail_boucliers(pos) * COUT_NEUTRALISATION_BOUCLIER + COUT_NEUTRALISATION;
        if (cout > nbPts)
            return false;
        nbPts -= cout;
        neutraliser();
    }
    
    // capturer
    
    if (portail_joueur(pos) != moi())
    {
        if (COUT_CAPTURE > nbPts)
            return false;
        nbPts -= COUT_CAPTURE;
        capturer();
    }
    
    // creer les liens
    
    std::vector<position> portails = liste_portails();
    for (int i = 0; i < (int)portails.size(); i++)
    {
        erreur e = lier(portails[i]);
        if (e == OK)
            nbPts -= COUT_LIEN;
        if (e == PA_INSUFFISANTS)
            return false;
    }
    
    // creer les boucliers
    
    //printf("\n %d boucliers case %d %d\n", act.nbBoucliers, act.portail.x, act.portail.y);
    
    /*int nbBoucliersPoses = portail_boucliers(pos);
    while (act.nbBoucliers > nbBoucliersPoses)
    {
        //printf("acheter un bouclier, il y en a maintenant %d\n", nbBoucliersPoses);
        if (nbPts < COUT_BOUCLIER)
            return false;
        nbPts -= COUT_BOUCLIER;
        ajouter_bouclier();
        nbBoucliersPoses++;
    }*/
    
    int ad = act.nbBoucliers - portail_boucliers(pos);
    while (ad > 0)
    {
        if (nbPts < COUT_BOUCLIER)
            return false;
        //printf("reste a poser %d boucliers\n", ad);
        nbPts -= COUT_BOUCLIER;
        ajouter_bouclier();
        ad--;
    }
    
    return true;
}

///
// Fonction appelée à chaque tour.
//
Action actAfaire;
void jouer_tour()
{
    
    int nbDeps = NB_POINTS_DEPLACEMENT, nbPts = NB_POINTS_ACTION;
    
    while (jouerAction(actAfaire, nbDeps, nbPts))
    {
        actAfaire = actionFind();
        if (actAfaire.portail.x == -1)
            break;
    }
}

///
// Fonction appelée à la fin de la partie.
//
void partie_fin()
{
  // fonction a completer
}

